unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ClipBrd, Buttons, ExtCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Save1: TMenuItem;
    Saveas1: TMenuItem;
    New1: TMenuItem;
    Edit1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Panel1: TPanel;
    SpeedButton1: TSpeedButton;
    FontDialog1: TFontDialog;
    Format1: TMenuItem;
    Character1: TMenuItem;
    procedure Open1Click(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Memo1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Memo1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Exit1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormResize(Sender: TObject);
    procedure Character1Click(Sender: TObject);
{    procedure N2Click(Sender: TObject);}
  private
   procedure SelCheck;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{uses search;}
{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
 if OpenDialog1.Execute then
  begin
   Memo1.Lines.LoadfromFile(OpenDialog1.FileName);
   Caption := ExtractFilename(OpenDialog1.FileName);
  end;
end;

procedure TForm1.Saveas1Click(Sender: TObject);
begin
 SaveDialog1.FileName:=Caption;
 if SaveDialog1.Execute then
  begin
   Memo1.Lines.SaveToFile(SaveDialog1.Filename);
   Caption := ExtractFilename(SaveDialog1.FileName);
  end;
end;

procedure TForm1.New1Click(Sender: TObject);
begin
 Memo1.Clear;
 Caption:='Nevtelen';
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
 if Caption <> 'Nevtelen' then
  Memo1.Lines.SaveToFile(Caption)
 else
  Saveas1Click(Sender);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 Caption:='Nevtelen';
 if Clipboard.HasFormat(CF_TEXT) then Paste1.Enabled:=true;
 Memo1.Height:=ClientHeight-Panel1.Height;
 FontDialog1.Font:=Memo1.Font;
end;

procedure TForm1.Cut1Click(Sender: TObject);
begin
 Memo1.CutToClipboard;
end;

procedure TForm1.Copy1Click(Sender: TObject);
begin
 Memo1.CopyToClipboard;
end;

procedure TForm1.Paste1Click(Sender: TObject);
begin
 Memo1.PasteFromClipboard;
end;

procedure TForm1.Memo1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 SelCheck;
end;

procedure TForm1.Memo1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 SelCheck;
end;

procedure TForm1.SelCheck;
begin
 if Clipboard.HasFormat(CF_TEXT) then Paste1.Enabled:=true
 else Paste1.Enabled:=false;
 if Memo1.SelText<>'' then
  begin
   Cut1.Enabled:=true;
   Copy1.Enabled:=true;
  end
 else
  begin
   Cut1.Enabled:=false;
   Copy1.Enabled:=false;
  end
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
 Close;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var valasz:word;
begin
 CanClose:=true;
 if Memo1.Modified then
  begin
   valasz:=MessageDlg('A dokumentum vltozott! Kvnja menteni?',mtWarning,[mbYes,mbNo,mbCancel],0);
   if valasz=mrYes then Save1Click(Sender);
   if valasz=mrCancel then CanClose:=false;
  end;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
 Memo1.Height:=ClientHeight-Panel1.Height;
end;

procedure TForm1.Character1Click(Sender: TObject);
begin
 if FontDialog1.Execute then Memo1.Font:=FontDialog1.Font;
end;

end.
