/*
 * extra csomag
 * Console.java
 *
 * Angster Erzsbet: OO tervezs s programozs, Java I. ktet
 * 2000.01.19.
 *
 * Beolvass a konzolrl:
 *
 * static int readInt()
 * static int readInt(String str)
 * static int readLong()
 * static int readLong(String str)
 * static double readDouble()
 * static double readDouble(String str)
 * static char readChar()
 * static char readChar(String str)
 * static String readLine()
 * static String readLine(String str)
 * static void pressEnter()
 */

package extra;

public class Console {
  // Az osztlybl nem lehet pldnyt ltrehozni:
  private Console() {
  }

  // ---------------------------------------------------------------------
  // Egsz (int) beolvassa:
  public static int readInt() {
    while(true) {
      try {
        return Integer.parseInt(readLine().trim());
      }
      catch(NumberFormatException e) {
        System.out.println("Nem egesz! Ujra!");
      }
    }
  }

  // ---------------------------------------------------------------------
  // Egsz (int) beolvassa, eltte prompt:
  public static int readInt(String str) {
    while(true) {
      System.out.print(str);
      try {
        return Integer.parseInt(readLine().trim());
      }
      catch(NumberFormatException e) {
        System.out.println("Nem egesz! Ujra!");
      }
    }
  }

  // ---------------------------------------------------------------------
  // Egsz (long) beolvassa:
  public static long readLong() {
    while(true) {
      try {
        return Long.parseLong(readLine().trim());
      }
      catch(NumberFormatException e) {
        System.out.println("Nem egesz! Ujra!");
      }
    }
  }

  // ---------------------------------------------------------------------
  // Egsz (long) beolvassa, eltte prompt:
  public static long readLong(String str) {
    while(true) {
      System.out.print(str);
      try {
        return Long.parseLong(readLine().trim());
      }
      catch(NumberFormatException e) {
        System.out.println("Nem egesz! Ujra!");
      }
    }
  }

  // ---------------------------------------------------------------------
  // Vals (double) beolvassa:
  public static double readDouble() {
    while(true) {
      try {
        return Double.parseDouble(readLine().trim());
      }
      catch(NumberFormatException e) {
        System.out.println("Nem valos! Ujra!");
      }
    }
  }

  // ---------------------------------------------------------------------
  // Vals (double) beolvassa, eltte prompt:
  public static double readDouble(String str) {
    while(true) {
      System.out.print(str);
      try {
        return Double.parseDouble(readLine().trim());
      }
      catch(NumberFormatException e) {
        System.out.println("Nem valos! Ujra!");
      }
    }
  }

  // ---------------------------------------------------------------------
  // Karakter beolvassa:
  public static char readChar() {
    while(true) {
      try {
        return readLine().charAt(0);
      }
      catch(IndexOutOfBoundsException e) {
        System.out.println("Nem karakter! Ujra!");
      }
    }
  }

  // ---------------------------------------------------------------------
  // Karakter beolvassa, eltte prompt:
  public static char readChar(String str) {
    System.out.print(str);
    return readChar();     
  }

  // ---------------------------------------------------------------------
  // String beolvassa sor vgig:
  public static String readLine() {
    int ch;
    String str = "";
    boolean done = false;
    while (!done) {
      try {
        ch = System.in.read();
        if (ch < 0 || (char)ch == '\n')
          done = true;
        else if ((char)ch != '\r')
          str = str + (char)ch;
      }
      catch(java.io.IOException e) {
        done = true;
      }
    }
    return str;
  }

  // ---------------------------------------------------------------------
  // String beolvassa sor vgig, eltte prompt:
  public static String readLine(String str) {
    System.out.print(str);
    return readLine();
  }

  // ---------------------------------------------------------------------
  // Vrs az ENTER lenyomsra:
  public static void pressEnter() {
    System.out.print("<ENTER>");
    readLine();
  }
}
