/* 
 * extra csomag
 * Format.java
 *
 * Angster Erzsbet: OO tervezs s programozs, Java I. ktet
 * 2000.01.19.
 * 
 * Szvegek igaztsa:
 *
 * static String left(String str, int len)
 * static String right(String str, int len)
 *
 * Szmok igaztsa:
 *
 * static String left(long num, int len)
 * static String right(long num, int len)
 * static String left(double num, int len, int frac)
 * static String right(double num, int len, int frac)
 */

package extra;
import java.text.*;
import java.util.*;

public class Format {
  // Az osztlybl nem lehet pldnyt ltrehozni:
  private Format() {
  }

  private static NumberFormat nf = NumberFormat.getInstance(Locale.US);
  final static String spaces =
    ("                                                 ");

  // ---------------------------------------------------------------------
  // String igaztsa balra, adott hosszra.
  // Ha kell, levgja, ha kell, kiegszti:
  public static String left(String str, int len) {
    int strLen = str.length();
    if (strLen > len)
      return str.substring(0,len);
    else
      return (str+spaces.substring(0,len-strLen));
  }

  // ---------------------------------------------------------------------
  // String igaztsa jobbra, adott hosszra.
  // Ha kell, levgja, ha kell, kiegszti:
  public static String right(String str, int len) {
    int strLen = str.length();
    if (strLen > len)
      return str.substring(0,len);
    else
      return (spaces.substring(0,len-strLen)+str);
  }

  // ---------------------------------------------------------------------
  // long szm konvertlsa Stringg. Igazts balra, len hosszon:
  public static String left(long num, int len) {
    nf.setGroupingUsed(false);
    nf.setMaximumFractionDigits(0);
    String str = nf.format(num);
    if (str.length() < len)
      str = str + spaces.substring(0,len-str.length());
    return str;
  }

  // ---------------------------------------------------------------------
  // long szm konvertlsa Stringg. Igazts jobbra, len hosszon:
  public static String right(long num, int len) {
    nf.setGroupingUsed(false);
    nf.setMaximumFractionDigits(0);
    String str = nf.format(num);
    if (str.length() < len)
      str = spaces.substring(0,len-str.length()) +  str;
    return str;
  }

  // ---------------------------------------------------------------------
  // double szm konvertlsa Stringg. Igazts balra, len hosszon
  // frac tizedesre:
  public static String left(double num, int len, int frac) {
    nf.setGroupingUsed(false);
    nf.setMaximumFractionDigits(frac);
    nf.setMinimumFractionDigits(frac);
    String str = nf.format(num);
    if (str.length() < len)
      str = str + spaces.substring(0,len-str.length());
    return str;
  }

  // ---------------------------------------------------------------------
  // double szm konvertlsa Stringg. Igazts jobbra, len hosszon
  // frac tizedesre:
  public static String right(double num, int len, int frac) {
    nf.setGroupingUsed(false);
    nf.setMaximumFractionDigits(frac);
    nf.setMinimumFractionDigits(frac);
    String str = nf.format(num);
    if (str.length() < len)
      str = spaces.substring(0,len-str.length()) +  str;
    return str;
  }
}
